/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSceneGraphException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;

class ClipRetained
extends LeafRetained {
    static final int BOUNDS_CHANGED = 1;
    static final int BOUNDINGLEAF_CHANGED = 2;
    static final int BACKDISTANCE_CHANGED = 4;
    double backDistance = 100.0;
    double backDistanceInVworld;
    Bounds applicationRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds transformedRegion = null;
    boolean inImmCtx = false;
    static final int targetThreads = 4224;
    boolean isViewScoped = false;

    ClipRetained() {
        this.nodeType = 2;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    final void initBackDistance(double d2) {
        this.backDistance = d2;
    }

    final void setBackDistance(double d2) {
        this.backDistance = d2;
        this.sendMessage(4, new Double(d2), null);
    }

    final double getBackDistance() {
        return this.backDistance;
    }

    final void initApplicationBounds(Bounds bounds) {
        this.applicationRegion = bounds != null ? (Bounds)bounds.clone() : null;
    }

    final void setApplicationBounds(Bounds bounds) {
        this.initApplicationBounds(bounds);
        if (this.boundingLeaf == null) {
            this.sendMessage(1, bounds != null ? bounds.clone() : null, null);
        }
    }

    final Bounds getApplicationBounds() {
        return this.applicationRegion != null ? (Bounds)this.applicationRegion.clone() : null;
    }

    void initApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    void setApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(2, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null, this.applicationRegion != null ? this.applicationRegion.clone() : null);
    }

    BoundingLeaf getApplicationBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    void setLive(SetLiveState setLiveState) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("ClipRetained0"));
        }
        super.doSetLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("ClipRetained1"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("ClipRetained2"));
        }
        this.initMirrorObject();
        if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
            setLiveState.viewScopedNodeList.add(this);
            setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
        } else {
            setLiveState.nodeList.add(this);
        }
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this, 1);
        }
        this.switchState = (SwitchState)setLiveState.switchStates.get(0);
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this, 1);
            setLiveState.notifyThreads |= 0x2000;
        }
        setLiveState.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (setLiveState.viewScopedNodeList != null && setLiveState.viewLists != null) {
            setLiveState.viewScopedNodeList.add(this);
            setLiveState.scopedNodesViewList.add(setLiveState.viewLists.get(0));
        } else {
            setLiveState.nodeList.add(this);
        }
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this, 1);
            setLiveState.notifyThreads |= 0x2000;
        }
        setLiveState.notifyThreads |= 0x1080;
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this, 1);
        }
    }

    void initMirrorObject() {
        Transform3D transform3D = this.getLastLocalToVworld();
        if (this.boundingLeaf != null) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, transform3D);
        } else {
            this.transformedRegion = null;
        }
        this.backDistanceInVworld = this.backDistance * transform3D.getDistanceScale();
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n2 = (Integer)objectArray[1];
        Transform3D transform3D = this.getCurrentLocalToVworld();
        if ((n2 & 1) != 0) {
            if (objectArray[2] != null) {
                this.transformedRegion = ((Bounds)objectArray[2]).copy(this.transformedRegion);
                this.transformedRegion.transform(this.transformedRegion, transform3D);
            } else {
                this.transformedRegion = null;
            }
        } else if ((n2 & 2) != 0) {
            if (objectArray[2] != null) {
                this.transformedRegion = ((BoundingLeafRetained)objectArray[2]).transformedRegion;
            } else {
                Bounds bounds = (Bounds)objectArray[3];
                if (bounds != null) {
                    this.transformedRegion = bounds.copy(this.transformedRegion);
                    this.transformedRegion.transform(bounds, transform3D);
                } else {
                    this.transformedRegion = null;
                }
            }
        } else if ((n2 & 4) != 0) {
            this.backDistanceInVworld = (Double)objectArray[2] * transform3D.getDistanceScale();
        }
    }

    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.mirrorBoundingLeaf.switchState.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = this.applicationRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.applicationRegion, this.getCurrentLocalToVworld());
        } else {
            this.transformedRegion = null;
        }
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, this.getCurrentLocalToVworld());
        }
    }

    final void sendMessage(int n2, Object object, Object object2) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 21;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = object2;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        if (this.applicationRegion != null) {
            this.applicationRegion.transform(transformGroupRetained.transform);
        }
    }

    void getMirrorObjects(ArrayList arrayList, HashKey hashKey) {
        arrayList.add(this);
    }
}

